function [agrid,agridt,aagrid,Uhatb,Uhatbl,Uhate,UIIncEmp] = UpdateGridsLBD(t, params, order, bgrid, hgrid, wgrid, AveTau, opts)

%% Update grids for assets and consumption
    
    [r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);
    albt = geosum(r,bl,(T-t));
    alb = geosum(r,bl,(T-t+1));
    ca = 2;
    
%% Update grids

    if opts.gpu == 'y'
        agrid  = gpuArray(linspace(lb.a.^(1/ca),(ub.a+alb).^(1/ca),Na).^ca)-alb;
        agridt  = gpuArray(linspace(lb.a.^(1/ca),(ub.a+albt).^(1/ca),Na).^ca)-albt;
        aagrid  = gpuArray(linspace(-albt,ub.a,na));
        
        [bmeshupdate,ameshupdate] = ndgrid(bgrid,agrid);
        ameshupdate = gpuArray(ameshupdate);
        bmeshupdate = gpuArray(bmeshupdate);
    
        if strcmpi(opts.test,'UBI')
            chatbunemp = (1 + r).*repmat(ameshupdate,1,1,na) + IncFun(min(max(bmeshupdate,bl+eepsilon),MaxUI)) - (repmat(reshape(aagrid.',1,1,na),Nb,Na,1));
        else
            chatbunemp = (1 + r).*repmat(ameshupdate,1,1,na) + min(max(bmeshupdate,bl+eepsilon),MaxUI) - (repmat(reshape(aagrid.',1,1,na),Nb,Na,1));
        end
        Uhatb = U(chatbunemp);
        Uhatb(chatbunemp<=0) = -realmax./T;
        clear ameshupdate bmeshupdate chatbunemp;
        
        if strcmpi(opts.test,'UBI')
            chatblunemp = bsxfun(@minus,(1 + r).*agrid.' + IncFun(bl+eepsilon),reshape(aagrid,1,1,1,na));
        else
            chatblunemp = bsxfun(@minus,(1 + r).*agrid.' + bl+eepsilon,reshape(aagrid,1,1,1,na));
        end
        Uhatbl = U(chatblunemp);
        Uhatbl(chatblunemp<=0) = -realmax./T;
        clear chatblunemp;

        % [wmeshupdate,ameshupdate] = ndgrid(wgrid,agrid);
        % ameshupdate = gpuArray(ameshupdate);
        % wmeshupdate = gpuArray(wmeshupdate);

        % incemp = repmat(reshape((1 - AveTau),1,nt),Nh,1).*phi(repmat(hgrid.',1,nt),t);
        % chatemp2 = (1 + r).*repmat(agrid.',1,na,1) - (repmat(reshape(aagrid,1,na,1),Na,1,1));
        % if strcmpi(opts.test,'UBI')
        %     chate = bsxfun(@minus,(1 + r).*agrid.' + IncFun(wmeshupdate.*(1 - AveTau)),reshape(aagrid,1,1,1,na));
        % else
        %     chate = bsxfun(@minus,(1 + r).*agrid.' + bl+eepsilon,reshape(aagrid,1,1,1,na));
        % end
        UIIncEmp = min(max(b.*(1 - AveTau).*bsxfun(@times,wgrid.',reshape(phi(hgrid,t),1,Nh)),bl+eepsilon),MaxUI);
        chate = bsxfun(@minus,(1 + r).*agrid + (1 - AveTau).*bsxfun(@times,wgrid.',reshape(phi(hgrid,t),1,1,Nh)),reshape(aagrid,1,1,1,na));
        Uhate = U(chate);
        Uhate(chate<=0) = -realmax./T;
        clear chate;

    else
        agrid  = (linspace(lb.a.^(1/ca),(ub.a+alb).^(1/ca),Na).^ca)-alb;
        agridt  = (linspace(lb.a.^(1/ca),(ub.a+albt).^(1/ca),Na).^ca)-albt;
        aagrid  = (linspace(-albt,ub.a,na));
        
        [bmeshupdate,ameshupdate] = ndgrid(bgrid,agrid);

        chatbunemp = (1 + r).*repmat(ameshupdate,1,1,1,na) + min(max(rmeshupdate.*bmeshupdate,bl),MaxUI) - (repmat(reshape(aagrid.',1,1,1,na),Nb,Na,1));
        Uhatb = U(chatbunemp);
        Uhatb(chatbunemp<=0) = -realmax./T;
        clear ameshupdate bmeshupdate rmeshupdate chatbunemp;
    
        chatblunemp = bsxfun(@minus,(1 + r).*agrid.' + bl,reshape(aagrid,1,1,1,na));
        Uhatbl = U(chatblunemp);
        Uhatbl(chatblunemp<=0) = -realmax./T;
        clear chatblunemp;
        chatemp1 = repmat(reshape((1 - ttgrid),1,nt),Nh,1).*phi(repmat(hgrid.',1,nt));
        chatemp2 = (1 + r).*repmat(agrid.',1,na,1) - (repmat(reshape(aagrid,1,na,1),Na,1,1)); 
    end



end