function [ameshupdate] = UpdateSimGridsNoSearch(t, params, order, opts)

%% Update grids for assets and consumption
    
    [r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar, ...
     llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL, ...
     SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq, ...
     Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);
    albt = geosum(r,bl,(T-t));
    alb = geosum(r,bl,(T-t+1));
    ca = 2;
    
%% Update grids

    if opts.gpu == 'y'
        agrid  = gpuArray(linspace(lb.a.^(1/ca),(ub.a+alb).^(1/ca),Na).^ca)-alb;
        agridt  = gpuArray(linspace(lb.a.^(1/ca),(ub.a+albt).^(1/ca),Na).^ca)-albt;
        aagrid  = gpuArray(linspace(-albt,ub.a,na));      
        
        [ameshupdate,~,~] = ndgrid(agrid,zeros(Nh,1),zeros(Nl,1));
        ameshupdate = gpuArray(ameshupdate);

    else
        agrid  = gpuArray(linspace(lb.a.^(1/ca),(ub.a+alb).^(1/ca),Na).^ca)-alb;
        agridt  = gpuArray(linspace(lb.a.^(1/ca),(ub.a+albt).^(1/ca),Na).^ca)-albt;
        aagrid  = gpuArray(linspace(-albt,ub.a,na));      
        
        [~,ameshbupdate,~,~] = ndgrid(zeros(Nb,1),agrid,zeros(Nh,1),zeros(Nl,1));
        [~,ameshupdate,~,~] = ndgrid(zeros(Nw,1),agrid,zeros(Nh,1),zeros(Nl,1));
        [ameshuupdate,~,~] = ndgrid(agrid,zeros(Nh,1),zeros(Nl,1));
    end
end