function V = WObjLBDEmpRisk(aprime,agridt,uhat,Rw,Rb,params,order,opts)

%VuEval: Solve for the value of the production period


% Load Parameters and Define Functional Forms
[r,ddelta,eeta,ggamma,bl,gg,b,ubi,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);


% Calculate the value of unemployement

% Nb x Nr x Na x Nh x Nl -> Na x Nr x Nb x Nh x Nl -> Nh x Nb x Nl x Nr x na
V    = reshape(permute(interp1(agridt.',permute(Rw,[3,1,2,4,5]),aprime.','linear'),[2,3,4,5,1]),Nd,Nw,1,Nh,Nl,na); % Interpolated value of return to search at aprime
clear Rw;
% Na x Nh x Nl -> Nh x Nl x na
V       = bsxfun(@plus,bsxfun(@times,reshape((1 - ddelta),Nd,1,1,1,1,1),V),bsxfun(@times,reshape(ddelta,Nd,1,1,1,1,1),reshape(permute(interp1(agridt.',permute(Rb,[3,1,2,4,5]),aprime.','linear'),[2,3,4,5,1]),Nd,Nw,1,Nh,Nl,na))); % Interpolated value of return to search at aprime
clear aprime Rb agridt;

V        = bsxfun(@plus,reshape(uhat,1,Nw,Na,Nh,1,na),bbeta.*V);                 % Value of unemployment

end