function err = confuneq( params, order , opts)
%UNTITLED4 Summary of this function goes here
%   Detailed explanation goes here
    
[r,ddelta,eeta,ggamma,bl,gg,UBI,b,MaxUI,bRet,kkappa,ssigma,nnu,T,TYoung,TOld,TScar,llambu,llambe,aalphah,eepsilon,lb,ub,delt,Nd,Na,Nb,Nw,Nh,Nl,na,nw,nt,N,NScar,S,MuA,MuH,MuL,SigA,SigH,SigL,SigAL,SigAH,SigHL,bbeta,U,p,q,xxi,phi,IncFun,w0,freq,bUITest,blUITest,bbarUITest,MaxUIUITest,ggammaUITest,iq,Epsnodes,MuEps,SigEps,StdEps,SigXi,MPIncreaseSA,MPDecreaseSA,MPIncreaseSH,MPDecreaseSH,MPIncreaseSL,MPDecreaseSL,exitProb,errtol] = Parameters(params, order, opts);

MuX = [ MuA MuH MuL ];
SigX = [ SigA SigH SigL ];
CorrMat = [1 SigAH SigAL ; SigAH 1 SigHL ; SigAL  SigHL 1];


err = 0;

try
    Y = LNRndCopula(MuX, SigX, CorrMat, N);
catch
    fprintf('Could not create log-normal copula')
    err = 1;
end

if lb.w >= ub.w
    fprintf('Lower bound on wages exceeded higher bound on wages')
    err = 1;
end

hgrid  = linspace(lb.h,ub.h,Nh);
lgrid  = linspace(lb.l,ub.l,Nl);
wgrid  = linspace(lb.w,ub.w,Nw);

[wmesht,hmesht,lmesht] = ndgrid(wgrid,hgrid,lgrid);

dxxiaalphah = @(h,ab,t)(exp(MuEps + SigEps.^(2)./2).*(aalphah.*w0.^(aalphah-1).*ab.*h.^(aalphah).*t.^(aalphah - 1)));
dxxigridMax = dxxiaalphah(hmesht,lmesht,ones(size(hmesht)));
dxxigridMin = dxxiaalphah(hmesht,lmesht,ones(size(hmesht))*eepsilon);

BoundCheckAllLearn = T.*(1 + r).*wmesht.*hmesht - dxxigridMax;
BoundCheckAllLearn = BoundCheckAllLearn(:);

BoundCheckNoLearn = (1 + r).*wmesht.*hmesht - T.*dxxigridMin;
BoundCheckNoLearn = BoundCheckNoLearn(:);

BoundCheckOneLearn = sum((1 + r).*wmesht.*hmesht - dxxigridMax,3);
BoundCheckOneLearn = BoundCheckOneLearn(:);

if sum(BoundCheckAllLearn<=0) > 0
    err = 1;
    fprintf('Sum of BoundCheckAllLearn was %1.1f\n',sum(BoundCheckAllLearn<=0))
end

if sum(BoundCheckNoLearn>=0) > 0
    err = 1;
    fprintf('Sum of BoundCheckNoLearn was %1.1f\n',sum(BoundCheckNoLearn>=0))
end

% $$$ if sum(BoundCheckOneLearn<=0) > 0
% $$$     err = 1;
% $$$     fprintf('Sum of BoundCheckOneLearn was %1.1f\n',sum(BoundCheckOneLearn<=0))
% $$$ end

clear hgrid lgrid wgrid wmesht hmesht lmesht dxxiaalphah dxxigridMax dxxigridMin BoundCheckAllLearn BoundCheckNoLearn BoundCheckOneLearn;

end

