function [ moments, weights, results_data ] = get_data( proj_dir, input_path )
% get_data m-file for Borrowing Constraints, Search, and Life-Cycle Inequality
% Author: Ben Griffy
% Date: Feb., 2018

    
    % Initial Distribution Moments
    init_earnings_moments = csvread(fullfile(proj_dir,input_path,'LRInc_qtiles.csv'));
    init_earnings_moments_weights = csvread(fullfile(proj_dir,input_path,'LRInc_qtiles_weighting.csv'));
    init_wealth_moments = csvread(fullfile(proj_dir,input_path,'RLiqWealth_qtiles.csv'));
    init_wealth_moments_weights = csvread(fullfile(proj_dir,input_path,'RLiqWealth_qtiles_weighting.csv'));
    
    % Life-Cycle PSID Profile Moments
    lifecycle_ave_moments = tabconv(fullfile(proj_dir,input_path,'LifeCycleProfiles_AveragePSID.csv'),'n');
    lifecycle_ave_moments_weights = tabconv(fullfile(proj_dir,input_path,'LifeCycleProfiles_AveragePSID_Weighting.csv'),'n');
    lifecycle_var_moments = tabconv(fullfile(proj_dir,input_path,'LifeCycleProfilesHVY_VariancePSID.csv'),'n');
    lifecycle_var_moments_weights = tabconv(fullfile(proj_dir,input_path,'LifeCycleProfilesHVY_VariancePSID_Weighting.csv'),'n');
    
    
    % Growth Rates PSID Moments
    lifecyclegrowth_ave_moments = tabconv(fullfile(proj_dir,input_path,'LifeCycleGrowth_AveragePSID.csv'),'n');
    lifecyclegrowth_ave_moments_weights = tabconv(fullfile(proj_dir,input_path,'LifeCycleGrowth_AveragePSID_Weighting.csv'),'n');
    lifecyclegrowth_covmat_moments = triu(tabconv(fullfile(proj_dir,input_path,'LifeCycleGrowth_VariancePSID.csv'),'n')).';
    lifecyclegrowth_covmat_moments = lifecyclegrowth_covmat_moments(:);
    lifecyclegrowth_covmat_moments(lifecyclegrowth_covmat_moments==0) = [];
    lifecyclegrowth_covmat_moments_weights = triu(tabconv(fullfile(proj_dir,input_path,'LifeCycleGrowth_VariancePSID_Weighting.csv'),'n')).';
    lifecyclegrowth_covmat_moments_weights = lifecyclegrowth_covmat_moments_weights(:);
    lifecyclegrowth_covmat_moments_weights(lifecyclegrowth_covmat_moments_weights==0) = [];
    
    % Life-Cycle PSID Slope-Intercept Moments
    slope_wealth_moments = tabconv(fullfile(proj_dir,input_path,'SlopesRLiqWealthOLogitPSID.csv'),'n');
    slope_wealth_moments_weights = tabconv(fullfile(proj_dir,input_path,'SlopesRLiqWealthOLogitPSID_Weighting.csv'),'n');
    
    % Life-Cycle NLSY Slope-Intercept Moments
    slope_ability_moments = tabconv(fullfile(proj_dir,input_path,'SlopesAFQTNLSY.csv'),'n');
    slope_ability_moments_weights = tabconv(fullfile(proj_dir,input_path,'SlopesAFQTNLSY_Weighting.csv'),'n');
    
    % Re-Emp Elasticity SIPP Moments
    wageelasticity_moments = tabconv(fullfile(proj_dir,input_path,'WageReEmploymentElasticities_SIPP.csv'),'n');
    wageelasticity_moments_weights = tabconv(fullfile(proj_dir,input_path,'WageReEmploymentElasticities_SIPP_Weighting.csv'),'n');

    % Re-Emp Elasticity SIPP Moments
    hazardelasticity_moments = tabconv(fullfile(proj_dir,input_path,'HazardReEmploymentElasticities_SIPP.csv'),'n');
    hazardelasticity_moments_weights = tabconv(fullfile(proj_dir,input_path,'HazardReEmploymentElasticities_SIPP_Weighting.csv'),'n');
    
    % Job Change Rates by Wealth NLSY    
    lifecycleJ2JRate_moments = tabconv(fullfile(proj_dir,input_path,'JobChangeRate_AverageNLSY.csv'),'n');
    lifecycleJ2JRate_moments_weights = tabconv(fullfile(proj_dir,input_path,'JobChangeRate_AverageNLSY_Weighting.csv'),'n');    

    % Unemployment Rate PSID    
    unempRate_moments = tabconv(fullfile(proj_dir,input_path,'UnempRatePSID.csv'),'n');
    unempRate_moments_weights = tabconv(fullfile(proj_dir,input_path,'UnempRatePSID_Weighting.csv'),'n');    

    % Initial Distributions
    init_earnings_data = csvread(fullfile(proj_dir,input_path,'LRInc_InitDistPSIDLiq.csv'),1,0);
    init_asset_data = csvread(fullfile(proj_dir,input_path,'RLiqWealth_InitDistPSIDLiq.csv'),1,0);
    
    % Sample Counts
    SIPPCount = tabconv(fullfile(proj_dir,input_path,'Sample_SIPP.csv'),'y');
    PSIDLCCount = tabconv(fullfile(proj_dir,input_path,'SlopesRLiqWealthOLogitUncondPSIDCount.csv'),'y');
    PSIDInitEarnCount = tabconv(fullfile(proj_dir,input_path,'LRInc_InitDistSamplePSIDLiq.csv'),'y');
    PSIDLiqWealthCount = tabconv(fullfile(proj_dir,input_path,'RLiqWealth_InitDistSamplePSIDLiq.csv'),'y');
    PSIDInitOverlapCount = tabconv(fullfile(proj_dir,input_path,'InitCondOverlapPSIDLiq.csv'),'y');
    NLSYLCCount = tabconv(fullfile(proj_dir,input_path,'SlopesAFQTUncondNLSYCount.csv'),'y');
    
    % Non-Targeted Moments and old moments that might be needed in other parts of code
    variance_data = csvread(fullfile(proj_dir,input_path,'variance_target.csv'));
    unemp_data = csvread(fullfile(proj_dir,input_path,'UnempPSID.csv'),1,1);
    lifetime_earnings = tabconv(fullfile(proj_dir,input_path,'LifeCycleProfiles_AverageUncondPSID.csv'),'n');
    lifetime_variance = tabconv(fullfile(proj_dir,input_path,'LifeCycleProfiles_VarianceUncondPSID.csv'),'n');
    UnempScarPooled_ave_data = readtable(fullfile(proj_dir,input_path,'UnempScarringEarningsPSIDAve_Plots.csv'));
    UnempScarPooled_ave_data(:,1:2) = [];
    UnempScarPooled_ave_data(end,:) = [];
    UnempScarPooled_ave_data = table2array(UnempScarPooled_ave_data);
    UnempScarPooled_ave_data = cell2mat(cellfun(@(x) str2num(x), UnempScarPooled_ave_data, 'UniformOutput', false));
    UnempScarPooled_se_data = readtable(fullfile(proj_dir,input_path,'UnempScarringEarningsPSIDAve_Plots_Weighting.csv'));
    UnempScarPooled_se_data(:,1:2) = [];
    UnempScarPooled_se_data(end,:) = [];
    UnempScarPooled_se_data = table2array(UnempScarPooled_se_data);
    UnempScarPooled_se_data = cell2mat(cellfun(@(x) str2num(x), UnempScarPooled_se_data, 'UniformOutput', false));
    UnempScar_ave_data = readtable(fullfile(proj_dir,input_path,'UnempScarringEarningsPSID.csv'));
    UnempScar_ave_data(:,1:2) = [];
    UnempScar_ave_data(end,:) = [];
    UnempScar_ave_data = table2array(UnempScar_ave_data);
    UnempScar_ave_data = cell2mat(cellfun(@(x) str2num(x), UnempScar_ave_data, 'UniformOutput', false));
    UnempScar_ave2_data = readtable(fullfile(proj_dir,input_path,'UnempScarringEarningsPSID_Plots.csv'));
    UnempScar_ave2_data(:,1:2) = [];
    UnempScar_ave2_data(end,:) = [];
    UnempScar_ave2_data = table2array(UnempScar_ave2_data);
    UnempScar_ave2_data = cell2mat(cellfun(@(x) str2num(x), UnempScar_ave2_data, 'UniformOutput', false));
    UnempScar_ave_data = cat(2,UnempScar_ave_data,UnempScar_ave2_data(:,2));
    UnempScar_se_data = readtable(fullfile(proj_dir,input_path,'UnempScarringEarningsPSID_Weighting.csv'));
    UnempScar_se_data(:,1:2) = [];
    UnempScar_se_data(end,:) = [];
    UnempScar_se_data = table2array(UnempScar_se_data);
    UnempScar_se_data = cell2mat(cellfun(@(x) str2num(x), UnempScar_se_data, 'UniformOutput', false));
    UnempScar_se2_data = readtable(fullfile(proj_dir,input_path,'UnempScarringEarningsPSID_Plots_Weighting.csv'));
    UnempScar_se2_data(:,1:2) = [];
    UnempScar_se2_data(end,:) = [];
    UnempScar_se2_data = table2array(UnempScar_se2_data);
    UnempScar_se2_data = cell2mat(cellfun(@(x) str2num(x), UnempScar_se2_data, 'UniformOutput', false));
    UnempScar_se_data = cat(2,UnempScar_se_data,UnempScar_se2_data(:,2));
    EmpRisk_ave_data = readtable(fullfile(proj_dir,input_path,'EmpRiskEarningsPSID.csv'));
    EmpRisk_ave_data(:,1:2) = [];
    EmpRisk_ave_data(end,:) = [];
    EmpRisk_ave_data = table2array(EmpRisk_ave_data);
    EmpRisk_ave_data = cell2mat(cellfun(@(x) str2num(x), EmpRisk_ave_data, 'UniformOutput', false));
    EmpRisk_ave2_data = readtable(fullfile(proj_dir,input_path,'EmpRiskEarningsPSID_Plots.csv'));
    EmpRisk_ave2_data(:,1:2) = [];
    EmpRisk_ave2_data(end,:) = [];
    EmpRisk_ave2_data = table2array(EmpRisk_ave2_data);
    EmpRisk_ave2_data = cell2mat(cellfun(@(x) str2num(x), EmpRisk_ave2_data, 'UniformOutput', false));
    EmpRisk_ave_data = cat(2,EmpRisk_ave_data,EmpRisk_ave2_data(:,2));
    EmpRisk_se_data = readtable(fullfile(proj_dir,input_path,'EmpRiskEarningsPSID_Weighting.csv'));
    EmpRisk_se_data(:,1:2) = [];
    EmpRisk_se_data(end,:) = [];
    EmpRisk_se_data = table2array(EmpRisk_se_data);
    EmpRisk_se_data = cell2mat(cellfun(@(x) str2num(x), EmpRisk_se_data, 'UniformOutput', false));
    EmpRisk_se2_data = readtable(fullfile(proj_dir,input_path,'EmpRiskEarningsPSID_Plots_Weighting.csv'));
    EmpRisk_se2_data(:,1:2) = [];
    EmpRisk_se2_data(end,:) = [];
    EmpRisk_se2_data = table2array(EmpRisk_se2_data);
    EmpRisk_se2_data = cell2mat(cellfun(@(x) str2num(x), EmpRisk_se2_data, 'UniformOutput', false));
    EmpRisk_se_data = cat(2,EmpRisk_se_data,EmpRisk_se2_data(:,2));    

    % UnempScar_ave_data = tabconv(fullfile(proj_dir,input_path,'UnempScarringEarningsPSID.csv'),'n');
    % UnempScar_se_data = tabconv(fullfile(proj_dir,input_path,'UnempScarringEarningsPSID_Weighting.csv'),'n');
    % EmpRisk_ave_data = tabconv(fullfile(proj_dir,input_path,'EmpRiskEarningsPSID.csv'),'n');
    % EmpRisk_se_data = tabconv(fullfile(proj_dir,input_path,'EmpRiskEarningsPSID_Weighting.csv'),'n');
    


    NumObs = struct('SIPP',SIPPCount(1),'PSIDTotal',PSIDLCCount(1),'PSIDInitEarn',PSIDInitEarnCount(1), ...
                    'PSIDInitWealth',PSIDLiqWealthCount(1),'PSIDInitOverlap',PSIDInitOverlapCount(1), ...
                    'NLSY',NLSYLCCount(1));
    
    
    NObsNames = struct('Aux1A','Sample_SIPP.csv','Aux1A_1','ReEmpElasticitiesSample1SIPP.csv','Aux1A_2','ReEmpElasticitiesSample2SIPP.csv', ...
                       'Aux1A_3','ReEmpElasticitiesSample3SIPP.csv','Aux1A_4','ReEmpElasticitiesSample4SIPP.csv','Aux1A_5','ReEmpElasticitiesSample5SIPP.csv', ...
                       'Aux1B','ReEmpElasticitiesSamplingDistSIPP.csv','Aux1C','ReEmpElasticitiesSelectionNoZerosPDFSIPP.csv', ...
                       'Aux2','RLiqWealth_InitDistSamplePSIDLiq.csv','Aux3','LRInc_InitDistSamplePSIDLiq.csv', ...
                       'Aux3HVY','SlopesRLiqWealthOLogitSampleUncondPSIDNOHVY.csv','Aux4','SlopesRLiqWealthOLogitSampleUncondPSID.csv', ...
                       'Aux4OldAve','LifeCycleGrowth_AverageSampleUncondPSID.csv','Aux4OldVar','LifeCycleGrowth_VarianceSampleUncondPSID.csv', ...
                       'Aux4_1','SlopesRLiqWealthOLogitSample1UncondPSID.csv','Aux4_2','SlopesRLiqWealthOLogitSample2UncondPSID.csv', ...
                       'Aux4_3','SlopesRLiqWealthOLogitSample3UncondPSID.csv','Aux4_4','SlopesRLiqWealthOLogitSample4UncondPSID.csv','Aux4_5','SlopesRLiqWealthOLogitSample5UncondPSID.csv', ...
                       'Aux4_1HVY','SlopesRLiqWealthOLogitSample1UncondPSIDNOHVY.csv','Aux4_2HVY','SlopesRLiqWealthOLogitSample2UncondPSIDNOHVY.csv', ...
                       'Aux4_3HVY','SlopesRLiqWealthOLogitSample3UncondPSIDNOHVY.csv','Aux4_4HVY','SlopesRLiqWealthOLogitSample4UncondPSIDNOHVY.csv','Aux4_5HVY', ...
                       'SlopesRLiqWealthOLogitSample5UncondPSIDNOHVY.csv', ...
                       'Aux5','SlopesAFQTSampleUncondNLSY.csv','Aux5_1','SlopesAFQTSample1UncondNLSY.csv','Aux5_2','SlopesAFQTSample2UncondNLSY.csv', ...
                       'Aux5_3','SlopesAFQTSample3UncondNLSY.csv','Aux5_4','SlopesAFQTSample4UncondNLSY.csv','Aux5_5','SlopesAFQTSample5UncondNLSY.csv', ...
                       'Aux5_1HVY','SlopesAFQTSample1UncondNLSYNOHVY.csv','Aux5_2HVY','SlopesAFQTSample2UncondNLSYNOHVY.csv', ...
                       'Aux5_3HVY','SlopesAFQTSample3UncondNLSYNOHVY.csv','Aux5_4HVY','SlopesAFQTSample4UncondNLSYNOHVY.csv','Aux5_5HVY','SlopesAFQTSample5UncondNLSYNOHVY.csv', ...
                       'UnempScar1','UnempScar1YearSamplePSID.csv','UnempScar1_1','UnempScar1YearSample1PSID.csv', ...
                       'UnempScar1_2','UnempScar1YearSample2PSID.csv','UnempScar1_3','UnempScar3YearSample3PSID.csv', ...
                       'UnempScar1_4','UnempScar1YearSample4PSID.csv','UnempScar1_5','UnempScar1YearSample5PSID.csv','UnempScar1_11stYN','UnempScar1YearSample1PSID_1styn.csv', ...
                       'UnempScar1_21stYN','UnempScar1YearSample2PSID_1styn.csv','EmpScar2','UnempScar1YearSamplePSID.csv', ...
                       'EmpScar2_1','UnempScar1YearSample1PSID.csv','EmpScar2_2','UnempScar1YearSample2PSID.csv','EmpScar2_3','UnempScar3YearSample3PSID.csv', ...
                       'EmpScar2_4','UnempScar1YearSample4PSID.csv','EmpScar2_5','UnempScar1YearSample5PSID.csv','EmpScar2_11stYN','UnempScar1YearSample1PSID_1styn.csv', ...
                       'EmpScar2_21stYN','UnempScar1YearSample2PSID_1styn.csv');
    
    moments = get_moments(wageelasticity_moments,hazardelasticity_moments,lifecycle_ave_moments,lifecycle_var_moments, ...
                                        lifecyclegrowth_ave_moments,lifecyclegrowth_covmat_moments, ...
                                        slope_ability_moments,slope_wealth_moments, ...
                                        init_earnings_moments,init_wealth_moments, ...
                                        lifecycleJ2JRate_moments,unempRate_moments);
    weights = get_weights(wageelasticity_moments_weights,hazardelasticity_moments_weights, ...
                                        lifecycle_ave_moments_weights,lifecycle_var_moments_weights, ...
                                        lifecyclegrowth_ave_moments_weights,lifecyclegrowth_covmat_moments_weights, ...
                                        slope_ability_moments_weights,slope_wealth_moments_weights, ...
                                        init_earnings_moments_weights,init_wealth_moments_weights, ...
                                        lifecycleJ2JRate_moments_weights,unempRate_moments_weights);

    
    results_data = struct('MomentObs',NumObs,'MomentObsNames',NObsNames,'Initial_Earnings', ...
                          init_earnings_data,'Initial_Wealth',init_asset_data, ...
                          'earnNorm',lifetime_earnings,'earnNormVar',lifetime_variance, ...
                          'Earnings_Profile',lifecycle_ave_moments,'Variance_Profile',lifecycle_var_moments, ...
                          'Unemp_Data',unemp_data,'variance_data',variance_data, ...
                          'UnempScarAve',UnempScar_ave_data,'UnempScarSE',UnempScar_se_data, ...
                          'UnempScarPooledAve',UnempScarPooled_ave_data,'UnempScarPooledSE',UnempScarPooled_se_data, ...
                          'EmpRiskAve',EmpRisk_ave_data,'EmpRiskSE',EmpRisk_se_data);
    

end