function [ params ] = get_params( II_path, II_params, default_params, opts )
% get_params m-file for Borrowing Constraints, Search, and Life-Cycle Inequality
% Author: Ben Griffy
% Date: May, 2018

if strcmpi(opts.params,'load_IIparams')
    params = default_params;
    Estparams = readtable(fullfile(pwd,II_path,'II.csv'));
    [~,minInd] = min(Estparams.ssr);
    
    for i = 1:length(II_params)
        setfield(params,II_params{i},Estparams(minInd,II_params(i)));
    end
elseif strcmpi(opts.params,'approxparams')
    params = default_params;
    [approxparams] = InitGuess(opts.project_path,opts.input_path);    
    for i = 1:length(II_params)
        params.(II_params{i}) = approxparams.(II_params{i});
    end
elseif strcmpi(opts.params,'HVY')
    params = struct('T',168,'TYoung',8,'TOld',40,'r',0.012,'ddelta',0.03,'ggamma',0.54,'eeta',0.5,'ddelth',0.95466198,'ddeltl',0.051743975,'eepsilon',0.00001, ...
                'ssigma',2.0,'llambe',0.26955732,'llambu',1.0,'MaxUI',450,'kkappa',0.2,'aalphah',0.34732565, ...
                'lba',0,'uba',75,'lbw',0.08,'ubw',1,'lbh',0,'ubh',30,'lbl',0,'ubl',0.35,'lbb',0,'ubb',1,'lbt',0,'ubt',1, ...
                'cons_pen',-realmax,'wsize',15,'rsize',7,'asize',20,'hsize',15,'lsize',8,'UIsize',12, ...
                'wwsize',5e2,'aasize',3e2,'ttsize',3e2,'N',default_params.TotSimN,'S',100,'MuRR',0.42,'SigRR',0.053,'StdRR',3, ...
                'bl',0.1812434,'nnu',0.0000042604902,'MuA',1.383464,'MuH',0.3359594,'MuL',-1.2926178,'Epsnodes',9,'MuEps',-0.07241831, ...
                'SigEps',0.12491099,'StdEps',3,'SigA',1.0165933,'SigH',0.69734566,'SigL',0.28754262,'SigAH',0.33267153,'SigAL',0.30110129, ...
                'SigHL',0.17548679,'freq',4);
else
    params = default_params;
end

end

