function spline_pts = makestataspline(data, npctiles)

%pctiles = interp1((100.0*(1:size(data,1))/size(data,1)),sort(data),100*(1:npctiles)./npctiles,'linear');

data(data(:,1)==-inf) = NaN;

datapctiles = tiedrank(data)/length(data);
pctiles = linspace(0,1,npctiles+1);
idx = zeros(npctiles,1);
ubqtiles = zeros(npctiles,1);
for i = 1:npctiles
    [~,idx(i,1)] = nanmin(abs(datapctiles - pctiles(i+1)));
    ubqtiles(i,1) = data(idx(i,1),1);
end

lbqtiles = [0;ubqtiles(1:end-1)];
dataqtiles = ceil(npctiles*tiedrank(data)/length(data));

spline_pts = repmat(data,1,npctiles);
lbqtiles = repmat(lbqtiles.',[size(data),1]);
ubqtiles = repmat(ubqtiles.',[size(data),1]);

spline_pts(spline_pts<lbqtiles&spline_pts<ubqtiles) = 0;
spline_pts(spline_pts>lbqtiles&spline_pts>ubqtiles) = ubqtiles(spline_pts>lbqtiles&spline_pts>ubqtiles) - lbqtiles(spline_pts>lbqtiles&spline_pts>ubqtiles);
spline_pts(spline_pts>lbqtiles&spline_pts<ubqtiles) = spline_pts(spline_pts>lbqtiles&spline_pts<ubqtiles) - lbqtiles(spline_pts>lbqtiles&spline_pts<ubqtiles);

end 