function [X, SE] = unifmultivarpdf( obj_fun , init_guess , lbnd , ubnd , opts )
%RndCopula
% Generate correlated draw from a log-normal distribution using a copula.
% CorrMat contains the correlations between the variables along the off-diagonals
% Simulations contains the number of draws
% Mu and Sigma are the mean and standard deviation of the marginal distribution of log-normals, respectively.
% Author: Ben Griffy
    
    proppdf = @(x,y) prod(1./(ubnd.' - lbnd.'));
    proprnd = @(x) x + rand;
    tgtpdf = obj_fun;
    
    if opts.burnin == 'n'
        [smpl,accept] = mhsample(init_guess,opts.nsamples,'pdf',tgtpdf,'proprnd',proprnd,'proppdf',proppdf,'symmetric',1);
    else
        [smpl,accept] = mhsample(init_guess,opts.nsamples,'pdf',tgtpdf,'proprnd',proprnd,'proppdf',proppdf,'burnin',opts.burnin,'symmetric',1);
    end

    accrate = accept/opts.nsamples;           % Acceptance rate
    if opts.burnin == 'n'
        X = 1./(opts.nsamples).*sum(smpl,1);
        SE = 1./(opts.nsamples).*sum((smpl - X).^2,1);
    else
        X = 1./(opts.nsamples-opts.burnin).*sum(smpl,1);
        SE = 1./(opts.nsamples).*sum((smpl - X).^2,1);
    end

end